//Experiment-14
// windows 8.1 - 64-Bit
//Scilab - 6.0.0
//Aim :Analyzing variation of slot leakage reactance in induction motor using SCILAB code
// Data: Plot graphs showing effect of no. of slots, length of armature core and no. of turns on slot leakage reactance

clc;
clear;

// Assumed data



bs=10 // slot opening in mm (in the range of 10 -30 mm)
wo=3 // width of lip in mm (in the range of 2 - 6 mm)
h1=30 // heigth of conductor portion in mm (in the range of 20 - 80 mm)
h2=1 // clearnace in mm (in the range of 1 - 4 mm)
h3=3.25 // wedge height in mm (in the range of 2 - 6 mm)
h4=1.2 // lip height in mm (in the range of 1 - 4 mm)

f=50; // frequency of supply
uo=4*%pi*1e-7; // pearmeabilty of free space
Ls=(h1/(3*bs))+(h2/(bs))+(2*h3/(bs+wo))+(h4/wo)

// Evaluating variation in leakage reactance with change in no. of slots
L=200
T=225
for s = 1:25
    xs(s)=8*%pi*f*uo*T^2*(L/1000)*Ls/s
end

x=1:25
figure(1)
plot(x,xs)
xlabel('No. of slots')
ylabel('Leakage reactance in Ohms')
title('Variation of leakage reactance with change in no. of slots')

clear xs s T L
// Evaluating variation in leakage reactance with change in length of core
L = 100:10:2000
s = 20
T = 225
for i = 1:length(L)
    xs(i)=8*%pi*f*uo*T^2*(L(i)/1000)*Ls/s
end
figure(2)
plot(L,xs)
xlabel('length of core in mm')
ylabel('Leakage reactance in Ohms')
title('Variation of leakage reactance with change in length of core')

clear xs s T L
// Evaluating variation in leakage reactance with change in no. of turns per phase
L = 200
s=20
T = 100:400
for i = 1:length(T)
    xs(i)=8*%pi*f*uo*T(i)^2*(L/1000)*Ls/s
end
figure(3)
plot(T,xs)
xlabel('No. of turns per phase')
ylabel('Leakage reactance in Ohms')
title('Variation of leakage reactance with change in no. of turns per phase')
